
************************************************************
************************************************************
***          Marriage and Happiness                      ***
***   Modeling Individual Growth (chap. VI)              ***
***		 Josef Brderl, Volker Ludwig                    *** 	   
***		            March 2015                           *** 	   
************************************************************
************************************************************

/* Data: SOEP 1984-2009 v26

We start with file "Happiness2.dta"
This file was prepared with "Happiness 2 DataPrep.do"

The lecture-package includes an anonymized version of this file:
A 50% random sample (on the person level), with artificial IDs,
and with a normally distributed random error (m=0, sd=10) added to
household income. Therefore, results are very similar, but not 
identical to the ones reported in the lecture. */


*************************************
** Preliminaries    *****************
*************************************
clear 
set seed 17838276                          //Set seed to replicate

* Load data
cd  "K:\Vorlesung PDA\Stata Beispiele\"    //Adapt this path!
use "Happiness2.dta", clear

***** Declare data to be panel data *****
xtset id year

*********   New variables needed below       ******************
bysort id: gen pycount = _N           //# of person-years (within person)

gen cohort = year - age              // birth cohort

egen cohgr = cut(cohort),                           ///group cohort
     at(1890,1910,1920,1930,1940,1950,1960,1970,1980,2000) icodes
table cohgr, contents(freq min cohort max cohort)   //verify the grouping

sum age
gen agec = age - r(mean)             // age centered



***************************************************************
****         Simple Growth Curve Analysis                  ****
***************************************************************
* c.age##c.age##c.age                        is equivalent to    
* c.age   c.age#c.age   c.age#c.age#c.age 

**** The POLS growth curve (without controling for cohort) ****
reg happy marry loghhinc c.age##c.age##c.age, vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("a) POLS without controlling for cohort")
graph save plotapc1, replace

************* The POLS growth curve ****************************
reg happy marry loghhinc c.age##c.age##c.age ib(last).cohort, vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("b) POLS with controlling for cohort")    
graph save plotapc2, replace

************** The RE growth curve *****************************
xtreg happy marry loghhinc c.age##c.age##c.age ib(last).cohort, re vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("c) RE with controlling for cohort")    
graph save plotapc3, replace
		
************** The FE growth curve *****************************
xtreg happy marry loghhinc c.age##c.age##c.age, fe vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("d) FE (implicitly controlling for cohort)")    
graph save plotapc4, replace

graph combine "plotapc1" "plotapc2" "plotapc3" "plotapc4", iscale(*.8)

		
************* The cohort effects ****************************
xtreg happy marry loghhinc c.age##c.age##c.age i.cohgr, re vce(cluster id)
margins, dydx(i1.cohgr i2.cohgr i3.cohgr i4.cohgr i5.cohgr i6.cohgr i7.cohgr i8.cohgr)
marginsplot, yline(0)  
	

	
************************************************************
****************** The APC Problem  ************************
************************************************************

* When entering period dummies we run into the APC-Problem
xtreg happy marry loghhinc c.age##c.age##c.age i.year, fe vce(cluster id)


* Unfortunately the growth curve is not robust against APC-restrictions
* We estimate several RE models with different restrictions

************** Age-Cohort Model *****************************
xtreg happy marry loghhinc c.age##c.age##c.age i.cohort, re vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))    ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("a) period (missing), cohort (dummies)")
graph save plotapc1, replace

************** Age-Period Model *****************************
xtreg happy marry loghhinc c.age##c.age##c.age i.year, re vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))    ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("b) period (dummies), cohort (missing)")
graph save plotapc2, replace

************** Age-Period Cohort(grouped) Model **************
xtreg happy marry loghhinc c.age##c.age##c.age i.year i.cohgr, re vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))    ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("c) period (dummies), cohort (10 yrs groups)")
graph save plotapc3, replace


************** Age-Cohort Period(restricted) Model *************
* Deciding which restrictions to use (RE model without cohort)
* xtreg happy marry loghhinc c.age##c.age##c.age i.year, re vce(cluster id)
xtreg happy marry loghhinc c.age##c.age##c.age i.cohort i(1987/1989 1992/2009)bn.year, re vce(cluster id)
margins, at(age=(18(4)98)) noatlegend
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100)         ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))    ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title("d) period (84/85/86/90/91 base), cohort (dummies)")
graph save plotapc4, replace

graph combine "plotapc1" "plotapc2" "plotapc3" "plotapc4", iscale(*.8)

		
	
/*******************************************************************
**** FE GC with age dummies   (and panel conditioning)        *****
*******************************************************************
keep if age>17 & age<91               //restricting age range 
bysort id (year): gen pynr    = _n    //person-year ID (within person)
gen panc=0                            //waves 1-3
replace panc=1 if pynr==1
replace panc=2 if pynr==2
replace panc=3 if pynr==3

xtreg happy marry loghhinc i.age i(1987/1989 1992/2009)bn.year i.panc, fe vce(cluster id)  
margins age, noatlegend                                  //takes several minutes
marginsplot, recast(line) recastci(rline)		                ///
        ylabel(0(1)10, grid angle(0)) xlabel(10(10)100, grid)   ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(green))   ///
		title(" ")   
*/

		
***************************************************************
****             Sex Specific Growth Curves FE             ****
***************************************************************

* FE growth curve (including period(restricted)) [age original]
xtreg happy marry loghhinc i.woman#(c.age##c.age##c.age) i(1987/1989 1992/2009)bn.year, fe vce(cluster id)
margins woman, at(age=(0(5)90)) noatlegend
marginsplot, recast(line) noci          	                    ///
        ylabel(0(1)10, grid angle(0)) xlabel(0(10)100)          ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(1) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title(" ") 

* FE growth curve (including period(restricted)) [age centered]
xtreg happy marry loghhinc i.woman#(c.agec##c.agec##c.agec) i(1987/1989 1992/2009)bn.year, fe vce(cluster id)
margins woman, at(agec=(-10(5)60)) noatlegend
marginsplot, recast(line) noci          	                    ///
        ylabel(0(1)10, grid angle(0)) xlabel(-29.3 "0" -19.3 "10" -9.3 "20" .7 "30" 10.7 "40" ///
		20.7 "50" 30.7 "60" 40.7 "70" 50.7 "80" 60.7 "90" 70.7 "100")    ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(1) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title(" ") 
		

/* HYBRID GCs (does not work: the same result as FE GC)
foreach var of varlist marry age loghhinc {
   bysort id: egen  m`var' = mean(`var')     //between component
   gen              d`var' = `var' - m`var'  //within component
}
xtreg happy   i.woman##c.age         marry         loghhinc,    re       //RE GCs
est store RE
xtreg happy   i.woman##c.age         marry         loghhinc,    fe       //FE GCs
est store FE
xtreg happy   i.woman##c.dage mage mmarry dmarry mloghhinc dloghhinc, re //Hybrid
est store HYBR

estimates table RE FE HYBR, star b(%9.4f)                              ///
         keep(1.woman age dage 1.woman#c.age 1.woman#c.dage) 
		
est restore HYBR
margins woman, at(dage=(0(5)90)) noatlegend   //Profile plot
marginsplot, recast(line) noci
*/

		
***************************************************************
****             Sex Specific Growth Curves RE             ****
***************************************************************

* RE growth curves (age-cohort-period(restricted) specification) [nested effects]
xtreg happy marry loghhinc i.woman i.woman#(c.agec##c.agec##c.agec) /// 
            ib(last).cohort i(1987/1989 1992/2009)bn.year, re vce(cluster id)
margins woman, at(agec=(-10(5)60)) noatlegend          //profile plot
marginsplot, recast(line) noci          	                    ///
        ylabel(0(1)8, grid angle(0)) xlabel(-9.3 "20" .7 "30" 10.7 "40"  ///
		20.7 "50" 30.7 "60" 40.7 "70" 50.7 "80" 60.7 "90")      ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(7) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title("profile plot") 
graph save plotgc1, replace
margins , at(agec=(-10(5)60)) dydx(woman) noatlegend  //conditional effect plot
marginsplot, recast(line) recastci(rline) yline(0)               ///
        ylabel(-1(0.25)1.5, grid angle(0) format(%3.2f))         ///
		xlabel(-9.3 "20" .7 "30" 10.7 "40"                       ///
		20.7 "50" 30.7 "60" 40.7 "70" 50.7 "80" 60.7 "90")       ///
        xtitle("Age", size(large) margin(0 0 0 2))               ///
        ytitle("AME of 'woman' on happiness", size(large))       ///
        plotopts(lpattern(solid) lwidth(thick) lcolor(blue))     ///
        ciopts(lpattern(dash) lwidth(medthick) lcolor(blue))     ///  
		title("conditional effect plot")
graph save plotgc2, replace

graph combine "plotgc1" "plotgc2", xsize(7)


/* Sex Specific Growth Curves RE with full set of age dummies
keep if age>17 & age<91               //restricting age range 
xtreg happy marry loghhinc i.woman i.woman#i.age i.panc /// nested effects
            ib(last).cohort i(1987/1989 1992/2009)bn.year, re
margins age, over(woman) noatlegend          //profile plot (takes 20 min.)
marginsplot, recast(line) noci          	                    ///
        ylabel(0(1)10, grid angle(0)) xlabel(0(10)100)          ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("Happiness", size(large))                        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(1) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title(" ") 
xtreg happy marry loghhinc i.woman##i.age i.panc /// standard specification
            ib(last).cohort i(1987/1989 1992/2009)bn.year, re
*/

* Conditional effect plot more general (if you have more than 2 groups)
* margins r.woman, at(agec=(-10(5)60)) noatlegend
* marginsplot, recast(line) recastci(rline) yline(0)  bydimension(woman)

		
/* Sex specific age effects [age original]
xtreg happy marry loghhinc i.woman#(c.age##c.age##c.age) i(1987/1989 1992/2009)bn.year, fe vce(cluster id)
margins , at(age=(20(5)90)) dydx(age) over(woman) noatlegend  //conditional effect plot
marginsplot, recast(line) noci yline(0)                         ///
        ylabel(-.25(0.05).05, grid angle(0) format(%3.2f))      ///
		xlabel(20(10)90)                                        ///
        xtitle("Age", size(large) margin(0 0 0 2))              ///
        ytitle("AME of 'age' on happiness", size(large))        ///
        plot1opts(lpattern(solid) lwidth(thick) lcolor(blue))  	///
        plot2opts(lpattern(solid) lwidth(thick) lcolor(red))  	///
		legend(pos(7) ring(0) row(2) order( 2 "Women" 1 "Men")  ///
		size(medlarge)) title("conditional effect plot by sex") 
* Testing for differences in GC slope
test (c.age             # 0.woman = c.age             # 1.woman) ///
     (c.age#c.age       # 0.woman = c.age#c.age       # 1.woman) ///
     (c.age#c.age#c.age # 0.woman = c.age#c.age#c.age # 1.woman)
*/
